﻿© Fluke Calibration. All Rights Reserved.                  MET/CAL Procedure
=============================================================================
INSTRUMENT:            Demo Procedure
DATE:                  2011-12-13 16:06:26
AUTHOR:                <add procedure writers name>
REVISION:              <add Revision information>
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       7
NUMBER OF LINES:       417
CONFIGURATION:         Fluke 5500A
STANDARD:              Manual Standard 1
=============================================================================
#
#  This sample procedure is for first time MET/CAL users, and contains
#  snippets of procedure code that you may find valuable, which can also be
#  reused when developing your own procedures.
#
#  MET/CAL Online Help:
#        MET/CAL has a help file that is available from Help menu,
#        or by pressing F1
#
#  Procedure Header:
#        A new procedure with an empty window with a procedure header like the
#        one above that contains basic information about the procedure.  At a
#        minimum, the user must enter a procedure name; everything else is
#        optional.
#
#  Function Select Codes (FSCs):
#        FSCs are the MET/CAL language or commands.  There are 7 classes.
#        Each is described in the MET/CAL online help file.
#            1) Display control
#            2) Non-instrument evaluation
#            3) Instrument control
#            4) Interface control
#            5) Memory register operation
#            6) Procedure control
#            7) Miscellaneous
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  DISP         It is recommended that you run this procedure in MET/CAL
  1.001  DISP         Editor Debug Mode, using Single Step Mode, to see the
  1.001  DISP         effect as each line executes.
  1.001  DISP
  1.001  DISP         Press F5 to Start Debugging, then press the F11 key to
  1.001  DISP         step through each line of this procedure, one at a time.

# =====  System Behavior  ===================================================

# The ASK+ and ASK- FSCs control MET/CAL runtime behavior like Automatic
# Messages, Stimulus Evaluation Statement Options, Post Test Options,
# and Miscellaneous behavior.
#
# This combination of commands forces the MET/CAL run-time to operate in the
# SLEW mode.  The Post-Test window will only be shown if there is a test
# failure.  The List, Cancel and Repeat buttons will be enabled.

  1.002  ASK+                        P                 X             L
  1.003  ASK-   R                                                 F        W

# =====  Measurement Uncertainty  ===========================================
#
# If you are planning to have MET/CAL report measurement uncertainty, or have
# the procedure comply with Z540.3, MET/CAL requires certain information.
#
# See the VSET or TSET help files, and the MET/CAL manual 'Guardbanding.pdf'
# for details.

  1.004  ASK+           K
  1.005  VSET         NMEAS = 1; ACCRED = YES; UFMT = PREFIX
  1.006  VSET         GBF = 0.8; GB = MU

# =====  Operator Messages  =================================================

# Use the DISP FSC to present a message to the operator.
  1.007  DISP         Please make the following connections:
  1.007  DISP
  1.007  DISP         [32]  5500A    to    UUT INPUT
  1.007  DISP         [32]NORMAL HI -----> V/Ohm
  1.007  DISP         [32]NORMAL LO -----> COM

  1.008  DISP         Rotate the UUT function switch to mV.

# Pictures can also be displayed by adding a PIC FSC.
  1.009  PIC          5520_8x_2w

# =====  Controlling a Fluke 5500A calibrator  ==============================

# This line programs the Fluke 5500A to source 1 Vdc, and sets a test
# tolerance of ±3 mV.  If the reading is within limits, the test passes.
  1.010  ASK-           K
  1.011  5500         1.000V         0.003U                                2W

# If the ASK commands are changed, the Run-Time behavior can also be changed.
# Here, the operator uses the keyboard to enter the UUT reading.
  2.001  ASK+           K
  2.002  5500         1.000V         0.003U                                2W

# NOTE: Measurement Uncertainity is only recorded when the data is entered
# through a keyboard entry, not SLEWing.  ASK+ K is required.

# =====  Using Variables and Memory Registers  ==============================
#
# MET/CAL supports named variables, as well as numeric and string memory
# registers.  The use of named variables is highly recommended for improved
# code readability.  The MATH FSC evaluates arithmetic and string expressions
# and assigns the result to a specified memory register.
#
#           MEM, MEM1                 -   global numeric registers
#			MEM2                      -   global string register
#			M[1], M[2], ..., M[255]   -   global numeric registers
#			L[1], L[2], ..., L[32]    -   local numeric registers
#			S[1], S[2], ..., S[32]    -   global string registers
#			@<variable>               -   global named variable
#			 <variable>               -   local named variable

# -----  Named Variables

# Note that variable names are case-sensitive: 'NAME' and 'name' are different
  3.001  MATH         NAME = 123; name = "ABX"
  3.002  DISP         Variable names are case-sensitive:
  3.002  DISP         [32] NAME = "[V NAME]"
  3.002  DISP         [32] name = "[V name]"

# Prompt the user for two numbers, store as local named variables.
  3.003  MEMI         Enter any number:
  3.004  MATH         First = MEM

  3.005  MEMI         Enter any second number:
  3.006  MATH         Second = MEM

# Multiply them together, store as global variable.
  3.007  MATH         @Result = First * Second

# Display the results.
  3.008  DISP         The two numbers have been multiplied:
  3.008  DISP         [32] [V First] * [V Second] = [V @Result]

# ----- Numeric Registers

# These are typically not used, in favor of named variables.  However, they
# work very well for certain operations like calculating RSS (square root of
# sum of squares) within a short subprocedure.  Each value contributes to a
# final calculated result, which will be passed to the calling procedure.

  3.009  MATH         L[1] = 5; L[2] = 8
  3.010  MATH         M[1] = RSS_L(1, 2)

# Format reading to 2 places.
  3.011  MATH         M[2] = FMT(M[1], "%4.2f")

# Display both.
  3.012  DISP         The RSS of [L1] and [L2]:
  3.012  DISP         [32] [M1]
  3.012  DISP
  3.012  DISP         Formatted to two places:
  3.012  DISP         [32] [M2]

# -----  String Registers

# String Registers are still supported, but mainly only to provide backwards
# compatibility with older procedures.  In most cases, the use of named
# variables is greatly preferred.

# Store two text strings into two different registers.
  3.013  MATH         S[1] = "abc"; S[2] = "def"

# Concatenate the two strings together into a third register.
  3.014  MATH         S[3] = S[1] & S[2]

# Display all three strings.
  3.015  DISP         First text string:  "[S1]"
  3.015  DISP         Second text string: "[S2]"
  3.015  DISP         Concatenated:       "[S3]"

# =====  Formatting Numbers  ================================================

# The FMT FSC allows the procedure writer to override the default formatting
# of result quantities.  Formatting specified in an FMT statement affects only
# how the result value is formatted in the database Results Table.
#
# The FMT FSC has no effect on how formatted values appear in:
#   (a) the Post Test window,
#   (b) the Test Results window, or
#   (c) the CalResults table (Legacy results).

# In this example, the results will be limited to 2 places after the decimal
# point.

  3.016  MATH         Results   = 1.23456
  3.017  MATH         Formatted = FMT(Results, "%.2f")
  3.018  DISP         [V Results] formatted to two places = [V Formatted]

# =====  Procedures Calling Other Procedures  ===============================

# One MET/CAL procedure can call another procedure.  Subprocedures can be used
# to separate procedure code into functional blocks, making it easier to
# develop, debug and maintain procedures.  This is often done with code which
# is repeated throughout a procedure.

  3.019  MATH         @Voltage = 120; @Current = 5
  3.020  MATH         @PhaseAngleInDegrees = 60
  3.021  CALL         Sub Compute Power

# Compute again using the same Voltage and Current, but a new Phase Angle.
  3.022  MATH         @PhaseAngleInDegrees = 70
  3.023  CALL         Sub Compute Power

# =====  Running External Programs  =========================================

# DOS and DOSE FSCs can run user-provided programs and batch files.  The
# programs may be MS-DOS executables, Windows executables, MS-DOS batch
# files, or Windows PIF files.
#
# The difference between the DOS and DOSE FSCs is that DOSE is an
# evaluation FSC which generates a result.

  3.024  DISP         The procedure will open 3 Windows programs.  To proceed
  3.024  DISP         with this procedure, close each program's window.

# Windows directory paths must be entered with either two backslashes...
  3.025  DOS          C:\\Windows\\notepad.exe

# ... or a single forward slash.
  3.026  DOS          C:/Windows/System32/calc.exe
  3.027  DOS          C:/Windows/System32/charmap.exe

# =====  Using Manual Calibration Standards  ================================

# The STD FSC is used by a procedure writer to indicate that a manual
# standard is a traceable reference.  # Press F12 to configure the manual
# standards.
#
# The ACC FSC enables MET/CAL to calculate a Test Uncertainty Ratio for
# a user-configured system instrument by allowing the procedure writer to
# specify the reference accuracy. The ACC FSC must be used in conjunction
# with an associated MEMC or MEMCX statement.

  3.028  STD          Manual Standard 1
  3.029  ACC          20.0psi        1.6%

# =====  Testing a UUT  =====================================================
#
# -----  Keyboard UUT data entry, manual pressure standard.

# This manual standard must be configured in advance.
  3.030  STD          Manual Standard 1

  3.031  HEAD         {20.0 psi Test}

# Establish the accuracy of the standard.
  3.032  ACC          20.0psi        0.90%

# Prompt the operator to set the test pressure.
  3.033  DISP         Set pressure source to 20.0 psi:

  3.034  MEMI         Enter the UUT reading in psi:

# Compare the reference to the UUT reading and see if it passes with a
# tolerance of ±4.02% of reading.
  3.035  MEMCX        psi            4.02%

# -----  Using SLEW

  4.001  STD          Manual Standard 1
  4.002  HEAD         {20.0 psi Test}
  4.003  ACC          20.0psi        0.90%
  4.004  DISP         Set pressure source to 20.0 psi:
  4.005  MATH         SLEWSTART(1)
  4.006  MATH         SLEWSCALE(1)
  4.007  MATH         SLEWMSG(0, "20.0 PSI Test")
  4.008  MATH         SLEWMSG(1, "")
  4.009  MATH         SLEWMSG(2, "Slew to the UUT reading.")
  4.010  MATH         SLEWMSG(3, "")
  4.011  MATH         SLEWINIT()
  4.012  MATH         MEM = 20.0

  4.013  DO
  4.014  MATH         MEM = SLEW(MEM, 1)
  4.015  MATH         OP = SLEWOP()
  4.016  UNTIL        (OP == 0) || (OP == 2) || (OP == 3)

  4.017  MEMC         psi            4.02%

# =====  Operator and Expression Based Evaluations  =========================
#
# The EVAL FSC allows evaluations based on operator prompts or evaluating a
# numeric expression.
#
# An operator-based EVAL presents a message to the operator and waits for a
# YES or NO response.  This response determines the result of the test (PASS
# or FAIL), and causes the value of MEM1 to be set to 1 or -1.
#
# An expression-based EVAL evaluates a numeric expression and, depending on
# whether the result is zero or not, determines the result of the test
# (PASS or FAIL), and causes the value of MEM1 to be set to 1 or -1.

  5.001  ASK-                                                     A

  5.002  MATH         Msg  = "Is the beam width < 0.125 inches?"
  5.003  EVAL   -s "Test #1" : [V Msg]

  6.001  MATH         Msg = "Is the reading between 0.075 and 1.025?"
  6.002  EVAL   -s "Test #2" : [V Msg]

  7.001  IF           MEM1 == 1
  7.002  DISP         The test passed.
  7.003  ELSE
  7.004  DISP         The test did not pass.
  7.005  ENDIF

# =====  Flow Control  ======================================================

# ----- Using IF / ELSEIF / ELSE / ENDIF

# In this example, the operator is asked to enter the UUT model number.  The
# test tolerance is then set depending on the model number entered.

  7.006  MEMI         Enter the UUT model number (83, 85 or 87):

  7.007  IF           MEM == 83
  7.008  DISP         The UUT is a Model 83.
  7.009  TOL          1.05%
  7.010  ELSEIF       MEM == 85
  7.011  DISP         The UUT is a Model 85.
  7.012  TOL          1.80%
  7.013  ELSEIF       MEM == 87
  7.014  DISP         The UUT is a Model 87.
  7.015  TOL          2.20%
  7.016  ELSE
  7.017  DISP         A valid UUT model number was not entered.  This
  7.017  DISP         procedure will use a default tolerace: ±5% of reading.
  7.018  TOL          5%
  7.019  ENDIF

# -----  Looping with WHILE - ENDW

# The WHILE - ENDW FSCs are used to repeat procedure statements until a
# specified condition is true.

# This procedure section executes a loop 10 times while counting down the
# value in the named variable 'Count'.

  7.020  MATH         Count = 10

  7.021  WHILE        Count > 0
  7.022  DISP         Loop count = [V Count]
  7.023  MATH         Count = Count - 1
  7.024  ENDW

  7.025  DISP         The WHILE - ENDW loop is now complete.

# -----  Looping with DO - UNTIL

# The DO - UNTIL FSCs are used to repeat procedure statements until a
# specified condition is true.

# This procedure section executes a loop 10 times while incrementing the
# value in the named variable 'Count'.

  7.026  MATH         Count = 0

  7.027  DO
  7.028  DISP         Loop count = [V Count]
  7.029  MATH         Count = Count + 1
  7.030  UNTIL        Count >= 10

  7.031  DISP         The DO - UNTIL loop is now complete.

# This section is similar to the IF/ENDIF example above, but shows a way to
# force entry of a valid UUT model number.  This loop will not exit until a
# valid model number is entered.

  7.032  DO
  7.033  MEMI         Enter the UUT model number (83, 85 or 87):
  7.034  UNTIL        (MEM == 83) || (MEM == 85) || (MEM == 87)


# =====  Waits and Delays ===================================================

# Delays can be used to wait for settling or other operations
# to complete. see the 5 second delay below.

  7.035  DISP         Begin 5 second delay.
  7.036  WAIT         -t 5 Please Standby...
  7.037  DISP         Delay complete.


# ====  Jumping and Branching  ==============================================

# Legacy jump statements (JMP, JMPF, JMPT, and JMPZ) remain supported, but
# their use is not recommended since they can make it very hard to interpret
# the intended flow of a procedure.

# JMPL and their corresponding LABELs remain widely used.

  7.038  DISP         The next step will jump to a DESTINATION label.
  7.039  JMPL         DESTINATION

  7.040  LABEL        ABORT
  7.041  DISP         You have chosen to abort this procedure.
  7.042  END

  7.043  LABEL        CONDITIONAL
  7.044  OPBR         -z Would you like to abort this procedure now?
  7.045  JMPL         ABORT                       MEM1
  7.046  JMPL         END

  7.047  LABEL        DESTINATION
  7.048  DISP         We have reached the DESTINATION label.
  7.048  DISP
  7.048  DISP         Next, we will perform a CONDITIONAL jump example.
  7.049  JMPL         CONDITIONAL

  7.050  LABEL        END
  7.051  DISP         The procedure has exited normally.
  7.052  END